/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.apps;

import java.util.Hashtable;
import java.util.Locale;
import net.sourceforge.jiu.apps.StringIndexConstants;

public class Strings
implements StringIndexConstants {
    public static final Integer LANG_ENGLISH = new Integer(0);
    public static final Integer LANG_GERMAN = new Integer(1);
    public static final Integer LANG_SPANISH = new Integer(2);
    public static final Integer LANG_FRENCH = new Integer(3);
    public static final Integer DEFAULT_LANGUAGE = LANG_ENGLISH;
    private static final String[] ISO_639_LANGUAGE_CODES = new String[]{"en", "de", "es", "fr"};
    private static final Integer[] LANGUAGE_CONSTANTS = new Integer[]{LANG_ENGLISH, LANG_GERMAN, LANG_SPANISH, LANG_FRENCH};
    public static final String DEFAULT_LANGUAGE_ISO_639_CODE = ISO_639_LANGUAGE_CODES[DEFAULT_LANGUAGE];
    private static Hashtable isoToConstant = new Hashtable(ISO_639_LANGUAGE_CODES.length);
    private String[] data;
    private Integer language;

    static {
        int i = 0;
        while (i < ISO_639_LANGUAGE_CODES.length) {
            isoToConstant.put(ISO_639_LANGUAGE_CODES[i], LANGUAGE_CONSTANTS[i]);
            ++i;
        }
    }

    public Strings(Integer languageConstant, String[] stringValues) {
        this.set(languageConstant, stringValues);
    }

    public static String determineSuitableIsoCode() {
        String code = Strings.determineIsoCodeFromDefaultLocale();
        if (code != null && Strings.findLanguageCode(code) != null) {
            return code;
        }
        return ISO_639_LANGUAGE_CODES[DEFAULT_LANGUAGE];
    }

    public static String determineIsoCodeFromDefaultLocale() {
        Locale locale = Locale.getDefault();
        if (locale == null) {
            return null;
        }
        return locale.getLanguage();
    }

    public static Integer findLanguageCode(String iso639LanguageCode) {
        if (iso639LanguageCode == null) {
            return null;
        }
        String code = iso639LanguageCode.toLowerCase();
        return (Integer)isoToConstant.get(code);
    }

    public String get(int index) {
        try {
            return this.data[index];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new IllegalArgumentException("Not a valid String index: " + index);
        }
    }

    public Integer getLanguage() {
        return this.language;
    }

    public static String getFileName(int languageCode) {
        if (languageCode >= 0 && languageCode < ISO_639_LANGUAGE_CODES.length) {
            return String.valueOf(ISO_639_LANGUAGE_CODES[languageCode]) + ".txt";
        }
        return null;
    }

    public void set(Integer languageConstant, String[] values) {
        if (languageConstant == null || languageConstant < 0 || languageConstant >= ISO_639_LANGUAGE_CODES.length) {
            throw new IllegalArgumentException("Not a valid language constant: " + languageConstant);
        }
        if (values == null || values.length < 1) {
            throw new IllegalArgumentException("The values array argument must be non-null and have at least one element.");
        }
        this.language = languageConstant;
        this.data = values;
    }
}

