/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs;

import java.io.DataInput;
import java.io.IOException;
import net.sourceforge.jiu.codecs.CodecMode;
import net.sourceforge.jiu.codecs.ImageCodec;
import net.sourceforge.jiu.codecs.InvalidFileStructureException;
import net.sourceforge.jiu.codecs.UnsupportedTypeException;
import net.sourceforge.jiu.codecs.WrongFileFormatException;
import net.sourceforge.jiu.data.Gray8Image;
import net.sourceforge.jiu.data.MemoryGray8Image;
import net.sourceforge.jiu.data.MemoryPaletted8Image;
import net.sourceforge.jiu.data.MemoryRGB24Image;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.OperationFailedException;

public class PSDCodec
extends ImageCodec {
    private static final int MAGIC_8BIM = 943868237;
    private static final int MAGIC_8BPS = 943870035;
    private static final int COLOR_MODE_GRAYSCALE = 1;
    private static final int COLOR_MODE_INDEXED = 2;
    private static final int COLOR_MODE_RGB_TRUECOLOR = 3;
    private static final short COMPRESSION_NONE = 0;
    private static final short COMPRESSION_PACKBITS = 1;
    private int magic;
    private int version;
    private int channels;
    private int height;
    private int width;
    private int depth;
    private int colorMode;
    private short compression;
    private DataInput in;
    private Gray8Image gray8Image;
    private Palette palette;
    private Paletted8Image paletted8Image;
    private RGB24Image rgb24Image;

    private void allocate() {
        this.gray8Image = null;
        this.paletted8Image = null;
        this.rgb24Image = null;
        if (this.depth == 8 && this.colorMode == 3) {
            this.rgb24Image = new MemoryRGB24Image(this.getBoundsWidth(), this.getBoundsHeight());
            this.setImage(this.rgb24Image);
        } else if (this.channels == 1 && this.depth == 8 && this.colorMode == 2) {
            this.paletted8Image = new MemoryPaletted8Image(this.width, this.height, this.palette);
            this.setImage(this.paletted8Image);
        } else if (this.channels == 1 && this.depth == 8 && this.colorMode == 1) {
            this.gray8Image = new MemoryGray8Image(this.width, this.height);
            this.setImage(this.gray8Image);
        } else {
            throw new IllegalArgumentException("Unknown image type in PSD file.");
        }
    }

    private static String getColorTypeName(int colorMode) {
        switch (colorMode) {
            case 0: {
                return "Black & white";
            }
            case 1: {
                return "Grayscale";
            }
            case 2: {
                return "Indexed";
            }
            case 3: {
                return "RGB truecolor";
            }
            case 4: {
                return "CMYK truecolor";
            }
            case 7: {
                return "Multichannel";
            }
            case 8: {
                return "Duotone";
            }
            case 9: {
                return "Lab";
            }
        }
        return "Unknown (" + colorMode + ")";
    }

    public String getFormatName() {
        return "Photoshop (PSD)";
    }

    public String[] getMimeTypes() {
        return new String[]{"image/psd", "image/x-psd"};
    }

    public boolean isLoadingSupported() {
        return true;
    }

    public boolean isSavingSupported() {
        return false;
    }

    private void load() throws InvalidFileStructureException, IOException, UnsupportedTypeException, WrongFileFormatException {
        this.loadHeader();
        if (this.width < 1 || this.height < 1) {
            throw new InvalidFileStructureException("Cannot load image. Invalid pixel resolution in PSD file header (" + this.width + " x " + this.height + ").");
        }
        if (this.colorMode != 3 && this.colorMode != 1 && this.colorMode != 2) {
            throw new UnsupportedTypeException("Cannot load image. Only RGB truecolor and indexed color are supported for PSD files. Found: " + PSDCodec.getColorTypeName(this.colorMode));
        }
        if (this.depth != 8) {
            throw new UnsupportedTypeException("Cannot load image. Only a depth of 8 bits per channel is supported (found " + this.depth + " bits).");
        }
        int colorModeSize = this.in.readInt();
        byte[] colorMap = null;
        if (this.colorMode == 2) {
            if (colorModeSize != 768) {
                throw new InvalidFileStructureException("Cannot load image. Color map length was expected to be 768 (found " + colorModeSize + ").");
            }
            colorMap = new byte[colorModeSize];
            this.in.readFully(colorMap);
            this.palette = new Palette(256, 255);
            boolean offset = false;
            int index = 0;
            while (index < 256) {
                this.palette.putSample(0, index, colorMap[index] & 0xFF);
                this.palette.putSample(1, index, colorMap[256 + index] & 0xFF);
                this.palette.putSample(2, index, colorMap[512 + index] & 0xFF);
                ++index;
            }
        } else {
            this.in.skipBytes(colorModeSize);
        }
        int resourceLength = this.in.readInt();
        this.in.skipBytes(resourceLength);
        int miscLength = this.in.readInt();
        this.in.skipBytes(miscLength);
        this.compression = this.in.readShort();
        if (this.compression != 0 && this.compression != 1) {
            throw new UnsupportedTypeException("Cannot load image. Unsupported PSD compression type (" + this.compression + ")");
        }
        this.loadImageData();
    }

    private void loadHeader() throws IOException, WrongFileFormatException {
        this.magic = this.in.readInt();
        if (this.magic != 943870035) {
            throw new WrongFileFormatException("Not a valid PSD file (wrong magic byte sequence).");
        }
        this.version = this.in.readShort();
        this.in.skipBytes(6);
        this.channels = this.in.readShort();
        this.height = this.in.readInt();
        this.width = this.in.readInt();
        this.depth = this.in.readShort();
        this.colorMode = this.in.readShort();
    }

    private void loadPackbitsCompressedData(byte[] data, int offset, int num) throws InvalidFileStructureException, IOException {
        int x = offset;
        int max = offset + num;
        while (x < max) {
            int n = this.in.readByte();
            boolean compressed = false;
            int count = -1;
            try {
                if (n >= 0) {
                    this.in.readFully(data, x, n + 1);
                    x += n + 1;
                    continue;
                }
                if (n == -128) continue;
                compressed = true;
                count = -n + 1;
                byte value = this.in.readByte();
                while (count-- > 0) {
                    data[x++] = value;
                }
            }
            catch (ArrayIndexOutOfBoundsException ioobe) {
                throw new InvalidFileStructureException("Error: RLE-compressed image file seems to be corrupt (x=" + x + ", count=" + (compressed ? -n + 1 : n) + ", compressed=" + (compressed ? "y" : "n") + ", array length=" + data.length + ").");
            }
        }
    }

    private void loadImageData() throws InvalidFileStructureException, IOException {
        this.setBoundsIfNecessary(this.width, this.height);
        this.allocate();
        if (this.compression == 1) {
            this.in.skipBytes(2 * this.channels * this.height);
        }
        byte[] data = new byte[this.width];
        int totalScanLines = this.channels * this.height;
        int currentScanLine = 0;
        int c = 0;
        while (c < this.channels) {
            boolean offset = false;
            int y = 0;
            int destY = -this.getBoundsY1();
            while (y < this.height) {
                if (this.compression == 1) {
                    this.loadPackbitsCompressedData(data, 0, this.width);
                } else if (this.compression == 1) {
                    this.in.readFully(data, 0, this.width);
                }
                this.setProgress(currentScanLine++, totalScanLines);
                if (this.isRowRequired(y)) {
                    if (this.rgb24Image != null) {
                        int channelIndex = 0;
                        if (c == 1) {
                            channelIndex = 1;
                        }
                        if (c == 2) {
                            channelIndex = 2;
                        }
                        this.rgb24Image.putByteSamples(channelIndex, 0, destY, this.getBoundsWidth(), 1, data, this.getBoundsX1());
                    }
                    if (this.gray8Image != null) {
                        this.gray8Image.putByteSamples(0, 0, destY, this.getBoundsWidth(), 1, data, this.getBoundsX1());
                    }
                    if (this.paletted8Image != null) {
                        this.paletted8Image.putByteSamples(0, 0, destY, this.getBoundsWidth(), 1, data, this.getBoundsX1());
                    }
                }
                ++y;
                ++destY;
            }
            ++c;
        }
    }

    public void process() throws OperationFailedException {
        this.initModeFromIOObjects();
        try {
            if (this.getMode() == CodecMode.LOAD) {
                this.in = this.getInputAsDataInput();
                if (this.in == null) {
                    throw new MissingParameterException("Input stream / file missing.");
                }
            } else {
                throw new OperationFailedException("Only loading is supported in PSD codec.");
            }
            this.load();
        }
        catch (IOException ioe) {
            throw new OperationFailedException("I/O error: " + ioe.toString());
        }
    }
}

