/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.data;

import net.sourceforge.jiu.color.data.Histogram1D;

public class ArrayHistogram1D
implements Histogram1D {
    private int[] data;

    public ArrayHistogram1D(int numValues) {
        if (numValues < 1) {
            throw new IllegalArgumentException("Must have at least one entry; numValues=" + numValues);
        }
        this.data = new int[numValues];
    }

    public void clear() {
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = 0;
            ++i;
        }
    }

    public int getEntry(int index) {
        try {
            return this.data[index];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new IllegalArgumentException("Not a valid index: " + index);
        }
    }

    public int getMaxValue() {
        return this.data.length - 1;
    }

    public int getNumUsedEntries() {
        int result = 0;
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i] > 0) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public void increaseEntry(int index) {
        try {
            int n = index;
            this.data[n] = this.data[n] + 1;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new IllegalArgumentException("Not a valid index: " + index);
        }
    }

    public void setEntry(int index, int newValue) {
        try {
            this.data[index] = newValue;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new IllegalArgumentException("Not a valid index: " + index);
        }
    }
}

