/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.data;

import net.sourceforge.jiu.color.data.CoOccurrenceMatrix;

public class MemoryCoOccurrenceMatrix
implements CoOccurrenceMatrix {
    private int dimension;
    private int dimSquare;
    private int[] data;

    public MemoryCoOccurrenceMatrix(int dimension) {
        if (dimension < 1) {
            throw new IllegalArgumentException("Dimension of co-occurrence matrix must be >= 1.");
        }
        this.dimension = dimension;
        long longDimSquare = (long)dimension * (long)dimension;
        if (longDimSquare > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Dimension " + dimension + " leads to an array exceeding the maximum size of 2^31 entries.");
        }
        this.dimSquare = dimension * dimension;
        this.data = new int[this.dimSquare];
    }

    public void clear() {
        int i = 0;
        while (i < this.dimSquare) {
            this.data[i] = 0;
            ++i;
        }
    }

    public int getDimension() {
        return this.dimension;
    }

    public int getValue(int i, int j) {
        if (i < 0 || i >= this.dimension || j < 0 || j >= this.dimension) {
            throw new IllegalArgumentException("co-occ matrix i/j arguments out of bounds: " + i + "/" + j);
        }
        return this.data[j * this.dimension + i];
    }

    public void incValue(int i, int j) throws IllegalArgumentException {
        int n = j * this.dimension + i;
        this.data[n] = this.data[n] + 1;
    }

    public void setValue(int i, int j, int newValue) {
        if (i < 0 || i >= this.dimension || j < 0 || j >= this.dimension) {
            throw new IllegalArgumentException("co-occ matrix setValue, i/j coordinate out of bounds: " + i + "/" + j);
        }
        this.data[j * this.dimension + i] = newValue;
    }
}

