/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.filters;

public class ConvolutionKernelData {
    private int[] data;
    private int width;
    private int height;
    private int div;
    private int bias;
    private String name;

    public ConvolutionKernelData(String name, int[] data, int width, int height, int div, int bias) {
        this.setName(name);
        this.setData(data);
        this.setWidth(width);
        this.setHeight(height);
        this.setDiv(div);
        this.setBias(bias);
        this.check();
    }

    public void check() {
        if (this.data.length < this.width * this.height) {
            throw new IllegalArgumentException("Kernel data array must have at least width * height elements.");
        }
    }

    public int getBias() {
        return this.bias;
    }

    public int getDiv() {
        return this.div;
    }

    public int[] getData() {
        return this.data;
    }

    public int getHeight() {
        return this.height;
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        return this.width;
    }

    public void setBias(int newBias) {
        this.bias = newBias;
    }

    public void setData(int[] newData) {
        if (newData == null) {
            throw new IllegalArgumentException("The data array must not be null.");
        }
        if (newData.length < 1) {
            throw new IllegalArgumentException("The data array must have a length of at least 1.");
        }
        this.data = newData;
    }

    public void setDiv(int newDiv) {
        if (newDiv == 0) {
            throw new IllegalArgumentException("Div value must not be 0.");
        }
        this.div = newDiv;
    }

    public void setHeight(int newHeight) {
        if (newHeight < 1) {
            throw new IllegalArgumentException("Height must be 1 or larger.");
        }
        if (newHeight % 2 == 0) {
            throw new IllegalArgumentException("Height must not be an even number.");
        }
        this.height = newHeight;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void setWidth(int newWidth) {
        if (newWidth < 1) {
            throw new IllegalArgumentException("Width must be 1 or larger.");
        }
        if (newWidth % 2 == 0) {
            throw new IllegalArgumentException("Width must not be an even number.");
        }
        this.width = newWidth;
    }
}

