/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.geometry;

import net.sourceforge.jiu.geometry.ResampleFilter;

public class Lanczos3Filter
extends ResampleFilter {
    private double sinc(double value) {
        if (value != 0.0) {
            return Math.sin(value *= Math.PI) / value;
        }
        return 1.0;
    }

    public float apply(float value) {
        if (value < 0.0f) {
            value = -value;
        }
        if (value < 3.0f) {
            return (float)(this.sinc(value) * this.sinc((double)value / 3.0));
        }
        return 0.0f;
    }

    public String getName() {
        return "Lanczos3";
    }

    public float getRecommendedSamplingRadius() {
        return 3.0f;
    }
}

