/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.geometry;

import net.sourceforge.jiu.geometry.ResampleFilter;

public class MitchellFilter
extends ResampleFilter {
    private final float B = 0.33333334f;
    private final float C = 0.33333334f;

    public float apply(float value) {
        if (value < 0.0f) {
            value = -value;
        }
        float tt = value * value;
        if (value < 1.0f) {
            value = 7.0f * (value * tt) + -12.0f * tt + 5.3333335f;
            return value / 6.0f;
        }
        if (value < 2.0f) {
            value = -2.3333333f * (value * tt) + 12.0f * tt + -20.0f * value + 10.666667f;
            return value / 6.0f;
        }
        return 0.0f;
    }

    public String getName() {
        return "Mitchell";
    }

    public float getRecommendedSamplingRadius() {
        return 2.0f;
    }
}

