/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.gui.awt.dialogs;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import net.sourceforge.jiu.gui.awt.dialogs.Dialogs;

public class IntegerDialog
extends Dialog
implements ActionListener,
AdjustmentListener,
KeyListener {
    private Button cancel;
    private int maxValue;
    private int minValue;
    private Button ok;
    private Integer result;
    private Scrollbar scrollbar;
    private TextComponent valueTextField;

    public IntegerDialog(Frame owner, String title, String message, int minValue, int initialValue, int maxValue, String okText, String cancelText) {
        super(owner, title, true);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.add((Component)new Label(message), "North");
        Panel panel = new Panel(new BorderLayout());
        this.scrollbar = new Scrollbar(0, initialValue, 1, minValue, maxValue + 1);
        this.scrollbar.addAdjustmentListener(this);
        panel.add((Component)this.scrollbar, "Center");
        this.valueTextField = new TextField(Integer.toString(initialValue), 6);
        this.valueTextField.addKeyListener(this);
        panel.add((Component)this.valueTextField, "East");
        this.add((Component)panel, "Center");
        panel = new Panel();
        this.ok = new Button(okText);
        this.ok.addActionListener(this);
        this.cancel = new Button(cancelText);
        this.cancel.addActionListener(this);
        panel.add(this.ok);
        panel.add(this.cancel);
        this.add((Component)panel, "South");
        this.pack();
        Dialogs.center(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            this.result = new Integer(this.scrollbar.getValue());
            this.setVisible(false);
        } else if (e.getSource() == this.cancel) {
            this.setVisible(false);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.valueTextField.setText(Integer.toString(this.scrollbar.getValue()));
    }

    public Integer getValue() {
        return this.result;
    }

    public void handleKeys(KeyEvent e) {
        this.setScrollbarFromTextField();
    }

    public void keyPressed(KeyEvent e) {
        this.handleKeys(e);
    }

    public void keyReleased(KeyEvent e) {
        this.handleKeys(e);
    }

    public void keyTyped(KeyEvent e) {
        this.handleKeys(e);
    }

    private void setScrollbarFromTextField() {
        int number;
        String text = this.valueTextField.getText().trim();
        try {
            number = Integer.parseInt(text);
        }
        catch (NumberFormatException nfe) {
            return;
        }
        if (number < this.minValue || number > this.maxValue) {
            return;
        }
        this.scrollbar.setValue(number);
    }
}

