/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.util;

public class ArrayRotation {
    private ArrayRotation() {
    }

    public static void checkPixelArray(int[] pixels, int width, int height) {
        if (pixels == null) {
            throw new IllegalArgumentException("Error -- the pixel array must be initialized.");
        }
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Error -- width and height must be >= 1 (width=" + width + ", height=" + height + ").");
        }
        if (pixels.length < width * height) {
            throw new IllegalArgumentException("Error -- pixel array must have at least width * height pixels, has only " + pixels.length + " pixels.");
        }
    }

    private static final void flipInPlace(int[] pixels, int width, int height) {
        ArrayRotation.checkPixelArray(pixels, width, height);
        int y1 = 0;
        int y2 = height - 1;
        while (y1 < y2) {
            int offset1 = y1 * width;
            int offset2 = y2 * width;
            int x = 0;
            while (x < width) {
                int temp = pixels[offset1];
                pixels[offset1++] = pixels[offset2];
                pixels[offset2++] = temp;
                ++x;
            }
        }
    }

    private static final int[] flip(int[] pixels, int width, int height) {
        ArrayRotation.checkPixelArray(pixels, width, height);
        int[] result = new int[width * height];
        int y1 = 0;
        int y2 = height - 1;
        while (y1 < height) {
            int offset1 = y1 * width;
            int offset2 = y2 * width;
            int x = 0;
            while (x < width) {
                result[offset2++] = pixels[offset1++];
                ++x;
            }
            ++y1;
            --y2;
        }
        return result;
    }

    public static final int[] flip(boolean inPlace, int[] pixels, int width, int height) {
        if (inPlace) {
            ArrayRotation.flipInPlace(pixels, width, height);
            return pixels;
        }
        return ArrayRotation.flip(pixels, width, height);
    }

    public static int[] mirror(boolean inPlace, int[] pixels, int width, int height) {
        if (inPlace) {
            return pixels;
        }
        return pixels;
    }

    public static int[] rotate180(boolean inPlace, int[] pixels, int width, int height) {
        if (inPlace) {
            ArrayRotation.rotateInPlace180(pixels, width, height);
            return pixels;
        }
        return pixels;
    }

    private static int[] rotate180(int[] pixels, int width, int height) {
        ArrayRotation.checkPixelArray(pixels, width, height);
        int numPixels = width * height;
        int[] result = new int[numPixels];
        int x1 = 0;
        int x2 = numPixels - 1;
        while (x1 < x2) {
            int temp = pixels[x1];
            pixels[x1++] = pixels[x2];
            pixels[x2--] = temp;
        }
        return result;
    }

    private static void rotateInPlace180(int[] pixels, int width, int height) {
        ArrayRotation.checkPixelArray(pixels, width, height);
        int x1 = 0;
        int x2 = width * height - 1;
        while (x1 < x2) {
            int temp = pixels[x1];
            pixels[x1++] = pixels[x2];
            pixels[x2--] = temp;
        }
    }

    private static void rotateToArray90Left(int[] src, int[] dest, int width, int height) {
        ArrayRotation.checkPixelArray(src, width, height);
        ArrayRotation.checkPixelArray(dest, width, height);
        if (src == dest) {
            throw new IllegalArgumentException("rotate90Left assumes that the argument arrays are not the same.");
        }
        int x_ = -1;
        int y_ = -1;
        try {
            int offset = 0;
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    x_ = x;
                    y_ = y;
                    dest[(width - x - 1) * height + y] = src[offset++];
                    ++x;
                }
                ++y;
            }
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            System.out.println("bounds; x=" + x_ + " y=" + y_);
        }
    }

    private static int pred(int k, int width, int height) {
        return k % height * width + k / height;
    }

    private static void rotateInPlace90Left(int[] pixels, int width, int height) {
        int LxM = height * width;
        int i = 0;
        int stillToMove = LxM;
        while (stillToMove > 0) {
            int j = ArrayRotation.pred(i, width, height);
            while (j > i) {
                j = ArrayRotation.pred(j, width, height);
            }
            if (j >= i) {
                int k = i;
                j = ArrayRotation.pred(i, width, height);
                while (j != i) {
                    int temp = pixels[k];
                    pixels[k] = pixels[j];
                    pixels[j] = temp;
                    --stillToMove;
                    k = j;
                    j = ArrayRotation.pred(j, width, height);
                }
                --stillToMove;
            }
            ++i;
        }
    }

    public static void rotate90Left(int width, int height, byte[] src, int srcOffset, byte[] dest, int destOffset) {
        int offset = srcOffset;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                dest[destOffset + (width - x - 1) * height + y] = src[offset++];
                ++x;
            }
            ++y;
        }
    }

    public static void rotate90Right(int width, int height, byte[] src, int srcOffset, byte[] dest, int destOffset) {
        int offset = srcOffset;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                dest[destOffset + x * height + (height - 1 - y)] = src[offset++];
                ++x;
            }
            ++y;
        }
    }

    public static void rotate180(int width, int height, byte[] src, int srcOffset, byte[] dest, int destOffset) {
        int n = width * height;
        destOffset = destOffset + n - 1;
        while (n-- > 0) {
            dest[destOffset--] = src[srcOffset++];
        }
    }

    private static void rotateInPlace90Right(int[] pixels, int width, int height) {
        throw new IllegalArgumentException("This method not implemented yet.");
    }

    private static int[] rotate90Right(int[] pixels, int width, int height) {
        int[] result = new int[width * height];
        int offset = 0;
        int y = 0;
        while (y < height) {
            int srcOffset = height - 1 - y;
            int x = 0;
            while (x < width) {
                result[srcOffset] = pixels[offset++];
                srcOffset += height;
                ++x;
            }
            ++y;
        }
        return result;
    }

    public static int[] rotate90Right(boolean inPlace, int[] pixels, int width, int height) {
        if (inPlace) {
            ArrayRotation.rotateInPlace90Right(pixels, width, height);
            return pixels;
        }
        return ArrayRotation.rotate90Right(pixels, width, height);
    }
}

