/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.util;

public class Statistics {
    private Statistics() {
    }

    public static double computeMean(double[] values) {
        return Statistics.computeMean(values, 0, values.length);
    }

    public static double computeMean(double[] values, int offset, int number) {
        if (number < 1) {
            throw new IllegalArgumentException("The number of values to process must be one or larger.");
        }
        double sum = 0.0;
        int UNTIL = offset + number;
        do {
            sum += values[offset++];
        } while (offset != UNTIL);
        return sum / (double)number;
    }

    public static double computeStandardDeviation(double[] values) {
        return Statistics.computeStandardDeviation(values, 0, values.length);
    }

    public static double computeStandardDeviation(double[] values, double mean) {
        return Statistics.computeStandardDeviation(values, 0, values.length, mean);
    }

    public static double computeStandardDeviation(double[] values, int offset, int number) {
        double mean = Statistics.computeMean(values, offset, number);
        return Statistics.computeStandardDeviation(values, 0, values.length, mean);
    }

    public static double computeStandardDeviation(double[] values, int offset, int number, double mean) {
        return Math.sqrt(Statistics.computeVariance(values, offset, number, mean));
    }

    public static double computeVariance(double[] values) {
        return Statistics.computeVariance(values, 0, values.length);
    }

    public static double computeVariance(double[] values, double mean) {
        return Statistics.computeVariance(values, 0, values.length, mean);
    }

    public static double computeVariance(double[] values, int offset, int number) {
        double mean = Statistics.computeMean(values, offset, number);
        return Statistics.computeVariance(values, 0, values.length, mean);
    }

    public static double computeVariance(double[] values, int offset, int number, double mean) {
        if (number < 2) {
            throw new IllegalArgumentException("The number of values to process must be two or larger.");
        }
        double sum = 0.0;
        int UNTIL = offset + number;
        do {
            double diff = values[offset++] - mean;
            sum += diff * diff;
        } while (offset != UNTIL);
        return sum / (double)(number - 1);
    }
}

